package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.PMMessage;
import gov.va.caret.service.PMMessageLocalServiceUtil;

/**
 * The extended model base implementation for the PMMessage service. Represents a row in the &quot;private_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PMMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMMessageImpl
 * @see gov.va.caret.model.PMMessage
 * @generated
 */
public abstract class PMMessageBaseImpl extends PMMessageModelImpl
    implements PMMessage {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a p m message model instance should use the {@link PMMessage} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PMMessageLocalServiceUtil.addPMMessage(this);
        } else {
            PMMessageLocalServiceUtil.updatePMMessage(this);
        }
    }
}
